/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.data;

import ch.varial.accounting.domain.payment.iso.data.PostalAddress;

public class PartyAgent {
    private final String bic;
    private final String name;
    private final String other;
    private final String bankSortingCode;
    private final PostalAddress postalAddress;

    private PartyAgent(Builder builder) {
        this.bic = builder.bic;
        this.name = builder.name;
        this.other = builder.other;
        this.bankSortingCode = builder.bankSortingCode;
        this.postalAddress = builder.postalAddress;
    }

    public String getBic() {
        return this.bic;
    }

    public String getName() {
        return this.name;
    }

    public String getOther() {
        return this.other;
    }

    public String getBankSortingCode() {
        return this.bankSortingCode;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String bic;
        private String name;
        private String other;
        private String bankSortingCode;
        private PostalAddress postalAddress;

        public PartyAgent build() {
            return new PartyAgent(this);
        }

        public Builder withBic(String bic) {
            this.bic = bic;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withOther(String other) {
            this.other = other;
            return this;
        }

        public Builder withBankSortingCode(String bankSortingCode) {
            this.bankSortingCode = bankSortingCode;
            return this;
        }

        public Builder withPostalAddress(PostalAddress postalAddress) {
            this.postalAddress = postalAddress;
            return this;
        }
    }
}

