/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.data;

import ch.varial.accounting.domain.payment.iso.data.PartyAccount;
import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChFieldFormatter;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.base.text.TextFactory;
import com.varial.serverbase.mapper.StringMapper;

public class PartyAccountFactory {
    private final Iso20022ChFieldFormatter formatter;

    public PartyAccountFactory(Iso20022ChFieldFormatter formatter) {
        this.formatter = formatter;
    }

    public PartyAccount create(TransactionType transactionType, FinancePayment payment) {
        switch (transactionType) {
            case TYPE_1: {
                return PartyAccount.builder().withOther(this.formatter.formatEsrMemberNumber(payment.getEsrPayment().getMemberNumber())).build();
            }
            case TYPE_21: {
                return PartyAccount.builder().withOther(this.formatter.formatPostChequeAccount(payment.getPostChequeAccount())).build();
            }
            case TYPE_3: 
            case TYPE_4: 
            case TYPE_6: {
                return this.createFromBankDetails(payment);
            }
            case TYPE_DD: {
                return PartyAccount.builder().withOther(this.formatter.formatFixPostChequeAccount(payment.getPostChequeAccount())).build();
            }
            case TYPE_TA: {
                return PartyAccount.builder().withIban(this.formatter.formatIban(payment.getShortAddressOwner())).build();
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)((Object)transactionType)));
    }

    private PartyAccount createFromBankDetails(FinancePayment payment) {
        if (!StringMapper.isNullString((String)payment.getShortAddressOwner())) {
            return PartyAccount.builder().withIban(this.formatter.formatIban(payment.getShortAddressOwner())).build();
        }
        if (!StringMapper.isNullString((String)payment.getBankAccountNumber())) {
            return PartyAccount.builder().withOther(this.formatter.formatBankAccountNumber(payment.getBankAccountNumber())).build();
        }
        return PartyAccount.builder().withOther(this.formatter.formatPostChequeAccount(payment.getPostChequeAccount())).build();
    }
}

