/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.data;

import ch.varial.accounting.domain.payment.iso.data.PostalAddress;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChFieldFormatter;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface AddressBuilderStrategy {
    public PostalAddress build(IPostalAddress var1);

    public static class UnstructuredAddressBuilder
    implements AddressBuilderStrategy {
        private static final String SEPARATOR = " ";
        private final Iso20022ChFieldFormatter formatter;

        public UnstructuredAddressBuilder(Iso20022ChFieldFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public PostalAddress build(IPostalAddress address) {
            PostalAddress base = new StructuredAddressBuilder(this.formatter).build(address);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.createLine1(base));
            lines.add(this.createLine2(base));
            return new PostalAddress(lines, base.getCountry());
        }

        private String createLine1(PostalAddress address) {
            return this.formatter.formatAddressLine(Stream.of(address.getStreet(), address.getBuildingNumber()).filter(s -> !StringMapper.isNullString((String)s)).collect(Collectors.joining(SEPARATOR)));
        }

        private String createLine2(PostalAddress address) {
            return this.formatter.formatAddressLine(Stream.of(address.getPostCode(), address.getTown()).filter(s -> !StringMapper.isNullString((String)s)).collect(Collectors.joining(SEPARATOR)));
        }
    }

    public static class StructuredAddressBuilder
    implements AddressBuilderStrategy {
        private final Iso20022ChFieldFormatter formatter;

        public StructuredAddressBuilder(Iso20022ChFieldFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public PostalAddress build(IPostalAddress address) {
            return new PostalAddress(this.formatter.formatAddressField(address.getStreet()), null, this.formatter.formatAddressField(address.getPostalCode()), this.formatter.formatAddressField(address.getTown()), this.formatter.formatAddressField(address.getCountry().getIsoCode()));
        }
    }
}

