/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso;

import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.serverbase.mapper.StringMapper;

public class TransactionTypeFactory {
    private static final String CHF = "CHF";
    private static final String EUR = "EUR";
    protected static final String FIX_POSTFINANCE_IID = "09000";
    private static final String[] POSTFINANCE_IID = new String[]{"9000", "09000"};

    private TransactionTypeFactory() {
    }

    public static TransactionType getCreditTransactionType(FinancePayment payment) {
        if (TransactionTypeFactory.isForeignPayment(payment)) {
            return TransactionType.TYPE_6;
        }
        if (TransactionTypeFactory.isForeignCurrency(payment)) {
            return TransactionType.TYPE_4;
        }
        if (TransactionTypeFactory.isEsrPayment(payment)) {
            return TransactionType.TYPE_1;
        }
        if (TransactionTypeFactory.isTransactionType21(payment)) {
            return TransactionType.TYPE_21;
        }
        return TransactionType.TYPE_3;
    }

    public static TransactionType getDebitTransactionType(FinancePayment payment) {
        return TransactionTypeFactory.isDD(payment) ? TransactionType.TYPE_DD : TransactionType.TYPE_TA;
    }

    private static boolean isTransactionType21(FinancePayment payment) {
        return !StringMapper.isNullString((String)payment.getPostChequeAccount()) && StringMapper.isNullString((String)payment.getShortAddressOwner()) && TransactionTypeFactory.getGeneratePaymentRemittances(payment).length == 1;
    }

    private static GeneratePaymentRemittance[] getGeneratePaymentRemittances(FinancePayment payment) {
        if (payment.isAdvancePayment()) {
            return new GeneratePaymentRemittance[0];
        }
        return ((GeneratePayment)payment).getGeneratePaymentRemittances();
    }

    private static boolean isForeignPayment(FinancePayment payment) {
        return !StringMapper.equalWithTrim((String)payment.getBankCountry().getIsoCode(), (String)payment.getBankAccount().getBankData().getCountry().getIsoCode());
    }

    private static boolean isForeignCurrency(FinancePayment payment) {
        return !StringMapper.equalWithTrim((String)CHF, (String)payment.getCurrency().getSwift()) && !StringMapper.equalWithTrim((String)EUR, (String)payment.getCurrency().getSwift());
    }

    private static boolean isEsrPayment(FinancePayment payment) {
        return payment.getEsrPayment() != null;
    }

    private static boolean isDD(FinancePayment payment) {
        return !StringMapper.isNullString((String)payment.getPostChequeAccount()) && TransactionTypeFactory.isPostFinanceIID(payment.getBankSortingCode()) && !StringMapper.isNullString((String)payment.getBankAccount().getPcCode()) && TransactionTypeFactory.isPostFinanceIID(payment.getBankAccount().getBankSortingCode());
    }

    private static boolean isPostFinanceIID(String bankSortingCode) {
        if (StringMapper.isNullString((String)bankSortingCode)) {
            return false;
        }
        for (String iid : POSTFINANCE_IID) {
            if (!StringMapper.equalWithTrim((String)bankSortingCode, (String)iid)) continue;
            return true;
        }
        return false;
    }
}

