/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso;

import ch.varial.accounting.domain.payment.iso.data.ChargeBearerType;
import ch.varial.accounting.domain.payment.iso.data.GroupHeaderData;
import ch.varial.accounting.domain.payment.iso.data.PartyAccount;
import ch.varial.accounting.domain.payment.iso.data.PartyAccountFactory;
import ch.varial.accounting.domain.payment.iso.data.PartyAgent;
import ch.varial.accounting.domain.payment.iso.data.PartyData;
import ch.varial.accounting.domain.payment.iso.data.PaymentInfoData;
import ch.varial.accounting.domain.payment.iso.data.PaymentTransferData;
import ch.varial.accounting.domain.payment.iso.data.PostalAddress;
import ch.varial.accounting.domain.payment.iso.data.PostalAddressFactory;
import ch.varial.accounting.domain.payment.iso.data.TransactionInfoData;
import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChFieldFormatter;
import ch.varial.accounting.domain.payment.iso.resolver.RemittanceResolver;
import ch.varial.accounting.domain.payment.iso.util.Iso20022ChPaymentUtils;
import com.varial.accounting.domain.bankaccount.IBankData;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.resolver.PersonalAccountBankAddressResolver;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.interfaces.IBankAccount;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class PaymentTransferDataMapper {
    protected Iso20022ChFieldFormatter formatter;
    private final PartyAccountFactory partyAccountFactory;

    protected PaymentTransferDataMapper(Iso20022ChFieldFormatter formatter) {
        this.formatter = formatter;
        this.partyAccountFactory = new PartyAccountFactory(formatter);
    }

    public List<PaymentTransferData> map(FinancePaymentSession session) throws BusinessDomainException {
        List<PaymentInfoData> paymentInfos = this.buildPaymentInfos(session);
        return this.createPaymentTransferData(session, paymentInfos);
    }

    private List<PaymentTransferData> createPaymentTransferData(FinancePaymentSession session, List<PaymentInfoData> paymentInfoDatas) throws BusinessDomainException {
        ArrayList<PaymentTransferData> transferDatas = new ArrayList<PaymentTransferData>();
        for (List<PaymentInfoData> grouped : this.groupPaymentInfos(paymentInfoDatas)) {
            transferDatas.add(this.buildPaymentTransferData(session, grouped));
        }
        return transferDatas;
    }

    private List<List<PaymentInfoData>> groupPaymentInfos(List<PaymentInfoData> paymentInfos) {
        HashMap<String, ArrayList<PaymentInfoData>> grouped = new HashMap<String, ArrayList<PaymentInfoData>>();
        for (PaymentInfoData paymentInfo : paymentInfos) {
            ArrayList<PaymentInfoData> paymentInfoList = (ArrayList<PaymentInfoData>)grouped.get(this.getPaymentInfoGroupByKey(paymentInfo));
            if (paymentInfoList == null) {
                paymentInfoList = new ArrayList<PaymentInfoData>();
                grouped.put(this.getPaymentInfoGroupByKey(paymentInfo), paymentInfoList);
            }
            paymentInfoList.add(paymentInfo);
        }
        return new ArrayList<List<PaymentInfoData>>(grouped.values());
    }

    private PaymentTransferData buildPaymentTransferData(FinancePaymentSession session, List<PaymentInfoData> paymentInfos) throws BusinessDomainException {
        PaymentTransferData paymentData = new PaymentTransferData();
        paymentData.setPaymentInfos(paymentInfos);
        paymentData.setHeader(this.createHeader(session, paymentInfos));
        paymentData.setGroupByValues(this.getPaymentInfoGroupByValues(paymentInfos.get(0)));
        return paymentData;
    }

    private List<PaymentInfoData> buildPaymentInfos(FinancePaymentSession session) throws BusinessDomainException {
        HashMap<String, PaymentInfoData> paymentInfos = new HashMap<String, PaymentInfoData>();
        int paymentInfoNo = 1;
        for (FinancePayment payment : session.getFinancePayments()) {
            TransactionInfoData transInfo = this.createTransactionInfo(payment, session.getIBankAccount(), session);
            PaymentInfoData paymentInfo = (PaymentInfoData)paymentInfos.get(this.getTransactionInfoGroupByKey(transInfo));
            if (paymentInfo == null) {
                paymentInfo = this.createPaymentInfo(session, paymentInfoNo++, transInfo);
                paymentInfos.put(this.getTransactionInfoGroupByKey(transInfo), paymentInfo);
            }
            paymentInfo.getTransactionInfos().add(transInfo);
        }
        for (PaymentInfoData paymentInfo : paymentInfos.values()) {
            this.setControlSum(paymentInfo);
            this.setTransactionIds(paymentInfo);
            this.sortTransactionsByPaymentId(paymentInfo);
        }
        ArrayList<PaymentInfoData> result = new ArrayList<PaymentInfoData>(paymentInfos.values());
        this.sortPaymentInfosById(result);
        return result;
    }

    private PaymentInfoData createPaymentInfo(FinancePaymentSession session, int paymentInfoNo, TransactionInfoData transactionInfo) throws BusinessDomainException {
        PaymentInfoData paymentInfo = new PaymentInfoData();
        paymentInfo.setPaymentInfoID(this.getPaymentInfoId(session, paymentInfoNo));
        paymentInfo.setRequestedExecutionDate(Iso20022ChPaymentUtils.getRequestedExecutionDate(session));
        paymentInfo.setPartyData(this.getCompanyPartyData(session));
        paymentInfo.setPartyAccount(this.getCompanyPartyAccount(session));
        paymentInfo.setPartyAgent(this.getCompanyPartyAgent(session, transactionInfo.getTransactionType()));
        paymentInfo.setTransactionType(transactionInfo.getTransactionType());
        paymentInfo.setLocalInstrument(transactionInfo.getLocalInstrument());
        paymentInfo.setCurrencyCode(transactionInfo.getCurrencyCode());
        return paymentInfo;
    }

    private GroupHeaderData createHeader(FinancePaymentSession session, List<PaymentInfoData> paymentInfos) throws BusinessDomainException {
        GroupHeaderData header = new GroupHeaderData();
        header.setCreationDateTime(session.getCreationDate());
        header.setInitiatingParty(this.getCompanyPartyData(session));
        header.setMessageID(this.getMessageId(session, paymentInfos));
        header.setCurrencyCode(this.getCurrencyCode(paymentInfos));
        header.setNumberOfTransactions(this.getNumberOfTransactions(paymentInfos));
        header.setControlSum(this.getControlSum(paymentInfos));
        return header;
    }

    private TransactionInfoData createTransactionInfo(FinancePayment payment, IBankAccount bankAccount, FinancePaymentSession session) throws BusinessDomainException {
        TransactionInfoData tx = new TransactionInfoData();
        tx.setEndToEndId(this.createEndToEndId(payment));
        tx.setAmount(payment.getCurrency().round(payment.getAmount()));
        tx.setCurrencyCode(payment.getCurrency().getSwift());
        TransactionType transactionType = this.getTransactionType(payment);
        tx.setTransactionType(transactionType);
        TransactionType.LocalInstrument localInstrument = this.getLocalInstrument(transactionType, payment);
        tx.setLocalInstrument(localInstrument);
        tx.setPartyAccount(this.partyAccountFactory.create(transactionType, payment));
        tx.setPartyData(this.getPartyData(transactionType, payment));
        tx.setPartyAgent(this.getPartyAgent(transactionType, payment, session));
        tx.setRemittanceInformation(new RemittanceResolver(this.formatter).resolveRemittance(transactionType, payment, bankAccount, localInstrument, session));
        tx.setPurposeCode(payment.getPurposeCode());
        return tx;
    }

    private String getPaymentInfoId(FinancePaymentSession session, int paymentInfoNo) {
        return this.formatter.formatId(Iso20022ChPaymentUtils.getSessionName(session) + "/" + paymentInfoNo);
    }

    protected PostalAddress getBankPostalAddress(FinancePayment payment, FinancePaymentSession session) {
        IBankData bankData = PersonalAccountBankAddressResolver.resolveBankData((Payment)payment, (PaymentSession)session);
        if (bankData == null) {
            return null;
        }
        IPostalAddress address = bankData.getPostalAddress();
        if (address == null) {
            return null;
        }
        return new PostalAddressFactory(this.formatter).withStructuredFormat().create(address);
    }

    protected String getPartyName(FinancePayment payment) {
        return payment.getPostalAddress() != null ? this.formatPartyName(payment.getPostalAddress().getName()) : null;
    }

    private String formatPartyName(String partyName) {
        return this.formatter.formatName(partyName);
    }

    private String createEndToEndId(FinancePayment payment) {
        return this.formatter.formatId(Iso20022ChPaymentUtils.getReferenceNumber(payment));
    }

    private String getCurrencyCode(List<PaymentInfoData> paymentInfos) {
        return paymentInfos.get(0).getCurrencyCode();
    }

    private void setTransactionIds(PaymentInfoData paymentInfo) {
        int txNo = 1;
        for (TransactionInfoData tx : paymentInfo.getTransactionInfos()) {
            tx.setPaymentId(this.formatter.formatId(paymentInfo.getPaymentInfoID() + "/" + txNo++));
        }
    }

    private void sortTransactionsByPaymentId(PaymentInfoData paymentInfo) {
        List<TransactionInfoData> transInfos = paymentInfo.getTransactionInfos();
        transInfos.sort((p1, p2) -> p1.getPaymentId().compareTo(p2.getPaymentId()));
        paymentInfo.setTransactionInfos(transInfos);
    }

    private void sortPaymentInfosById(List<PaymentInfoData> paymentInfos) {
        paymentInfos.sort((p1, p2) -> p1.getPaymentInfoID().compareTo(p2.getPaymentInfoID()));
    }

    private void setControlSum(PaymentInfoData paymentInfo) {
        paymentInfo.setControlSum(this.getControlSum(paymentInfo));
    }

    protected String getCompanyName(FinancePaymentSession session) throws BusinessDomainException {
        return this.formatter.formatName(Iso20022ChPaymentUtils.getCompanyName(session));
    }

    protected PostalAddress createCompanyPostalAddress(FinancePaymentSession session) throws BusinessDomainException {
        return new PostalAddressFactory(this.formatter).withUnstructuredFormat().create((IPostalAddress)Iso20022ChPaymentUtils.getCompanyPostalAddress(session));
    }

    protected String getMessageId(FinancePaymentSession session, List<PaymentInfoData> paymentInfos) {
        return this.formatter.formatId(Iso20022ChPaymentUtils.getSessionName(session) + this.getPaymentInfoGroupByKey(paymentInfos.get(0)) + " " + Iso20022ChPaymentUtils.getBankAccountCode(session));
    }

    protected String getBankName(FinancePayment payment) {
        return this.formatter.formatName(payment.getBankName());
    }

    private BigDecimal getControlSum(List<PaymentInfoData> paymentInfos) {
        BigDecimal sum = BigDecimalMapper.ZERO;
        for (PaymentInfoData paymentInfo : paymentInfos) {
            sum = BigDecimalMapper.add((BigDecimal)sum, (BigDecimal)paymentInfo.getControlSum());
        }
        return sum;
    }

    private BigDecimal getControlSum(PaymentInfoData paymentInfo) {
        BigDecimal sum = BigDecimalMapper.ZERO;
        for (TransactionInfoData tx : paymentInfo.getTransactionInfos()) {
            sum = BigDecimalMapper.add((BigDecimal)sum, (BigDecimal)tx.getAmount());
        }
        return sum;
    }

    private int getNumberOfTransactions(List<PaymentInfoData> paymentInfos) {
        int numberOfTransactions = 0;
        for (PaymentInfoData paymentInfo : paymentInfos) {
            numberOfTransactions += paymentInfo.getNumberOfTransactions();
        }
        return numberOfTransactions;
    }

    private String getPaymentInfoGroupByKey(PaymentInfoData paymentInfo) {
        return this.buildGroupByKey(this.getPaymentInfoGroupByValues(paymentInfo), '/');
    }

    private String buildGroupByKey(String[] values, char delimiter) {
        StringBuilder key = new StringBuilder();
        for (String value : values) {
            key.append(delimiter).append(value);
        }
        return key.toString();
    }

    protected abstract PartyAccount getCompanyPartyAccount(FinancePaymentSession var1);

    protected abstract PartyAgent getCompanyPartyAgent(FinancePaymentSession var1, TransactionType var2);

    protected abstract PartyAgent getPartyAgent(TransactionType var1, FinancePayment var2, FinancePaymentSession var3);

    protected abstract PartyData getCompanyPartyData(FinancePaymentSession var1) throws BusinessDomainException;

    protected abstract TransactionType.LocalInstrument getLocalInstrument(TransactionType var1, FinancePayment var2);

    protected abstract PartyData getPartyData(TransactionType var1, FinancePayment var2);

    protected abstract String[] getPaymentInfoGroupByValues(PaymentInfoData var1);

    protected abstract String getTransactionInfoGroupByKey(TransactionInfoData var1);

    protected abstract TransactionType getTransactionType(FinancePayment var1);

    protected abstract ChargeBearerType getChargeBearer(FinancePayment var1);
}

