/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso;

import ch.varial.accounting.domain.payment.iso.UnicodeCharacterEscapeHandlerISO20022CH;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.framework.domain.payment.sepa.base.UnicodeCharacterEscapeHandler;
import com.varial.framework.domain.paymentbase.BankDataChecker;
import com.varial.serverbase.mapper.StringMapper;

public class PaymentTransferDataFormatter {
    private static final int MAX_LENGTH = 35;
    public static final int MAX_UNSTRUCTURED_REMITTANCE_LENGTH = 140;
    private static final char[] WHITESPACE_CHARS = new char[]{' '};
    private static final char[] CONTROL_CHARS = new char[]{'\b', '\t', '\n', '\f', '\r', '\\'};
    private final UnicodeCharacterEscapeHandler escapeHandler = new UnicodeCharacterEscapeHandlerISO20022CH();

    public String format(String input, int maxLength) {
        String result = this.preprocess(input);
        return result.length() <= maxLength ? result : StringMapper.maxLength((String)result, (int)maxLength);
    }

    public String formatUniqueID(String uniqueID) {
        return this.format(uniqueID, 35);
    }

    public String formatReference(String referenceNumber) {
        return this.format(referenceNumber, 35);
    }

    public String formatUnstructuredReference(String reference) {
        return this.format(reference, 140);
    }

    public String formatFixPostChequeAccount(String account) {
        return BankDataChecker.toOcrBDataFormat((String)account);
    }

    public String formatIban(String iban) {
        return PaymentHelper.getIbanForElectronicFormat(iban);
    }

    public String formatEsrMemberNumber(String memberNumber) {
        return this.removeWhitespace(memberNumber);
    }

    public String formatEsrNumber(String esrNumber) {
        return this.removeWhitespace(esrNumber);
    }

    public String formatSwift(String swift) {
        return this.removeWhitespace(swift);
    }

    public String formatBankSortingCode(String bankSortingCode) {
        return this.removeWhitespace(bankSortingCode);
    }

    public String formatPostChequeAccount(String postChequeAccount) {
        return this.removeWhitespace(postChequeAccount);
    }

    public String formatBankAccountNumber(String bankAccountNumber) {
        return this.removeWhitespace(bankAccountNumber);
    }

    private String removeWhitespace(String value) {
        return StringMapper.removeChars((String)value, (char[])WHITESPACE_CHARS);
    }

    private String preprocess(String input) {
        if (StringMapper.isNullString((String)input)) {
            return "";
        }
        String cleaned = StringMapper.removeChars((String)input, (char[])CONTROL_CHARS);
        if ((cleaned = this.escapeHandler.checkField(cleaned.toCharArray())).contains("//")) {
            cleaned = StringMapper.replaceAllSubString((String)cleaned, (String)"//", (String)" ");
        }
        if (cleaned.startsWith("/")) {
            cleaned = cleaned.substring(1, cleaned.length());
        }
        return StringMapper.toStringWithTrim((String)cleaned);
    }
}

