/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso;

import ch.varial.accounting.domain.payment.iso.CreditTransferDataMapper;
import ch.varial.accounting.domain.payment.iso.DebitTransferDataMapper;
import ch.varial.accounting.domain.payment.iso.PaymentTransferDataMapper;
import ch.varial.accounting.domain.payment.iso.PaymentTransferService;
import ch.varial.accounting.domain.payment.iso.data.PaymentTransferData;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChEscapeHandler;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChFieldFormatter;
import ch.varial.accounting.domain.payment.iso.schemamapper.version3.credit.CreditService3;
import ch.varial.accounting.domain.payment.iso.schemamapper.version3.debit.DebitService3;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.report.PaymentReportHelper;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.FileExportStruct;
import com.varial.framework.domain.paymentbase.PaymentExporter;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.language.LocalizedStringStruct;
import com.varial.serverbase.mapper.StringMapper;
import java.nio.charset.StandardCharsets;

public class ISO20022PaymentExporter
extends PaymentExporter {
    private static final String FILE_NAME_PREFIX = "ISOCH_";
    private static final TranslateableResourceList LABELS = TranslateableResourceList.createTranslateableResourceList((String)"ISO20022CHlabelnames", (String[])new String[]{"Absender-ID", "Angabe Adresse des Absenders", "ESR-Teilnehmer"});
    private static final int COMPANY_UNIQUE_ID_LABEL = 0;
    private static final int COMPANY_ADDRESS_LABEL = 1;
    private static final int COMPANY_ESR_MEMBER_NUMBER_LABEL = 2;

    public FileExportStruct[] getFileExport() throws BusinessDomainException {
        return (FileExportStruct[])this.getPaymentTransferDataMapper().map(this.getPaymentSession()).stream().map(this::createFileExportStruct).toArray(FileExportStruct[]::new);
    }

    private FileExportStruct createFileExportStruct(PaymentTransferData transferData) {
        FileExportStruct result = new FileExportStruct();
        result.binaryData = this.createXmlBytes(transferData);
        result.fileName = this.buildFileName(transferData);
        return result;
    }

    private byte[] createXmlBytes(PaymentTransferData transferData) {
        return this.getPaymentTransferService().toXML(transferData).getBytes(StandardCharsets.UTF_8);
    }

    private String buildFileName(PaymentTransferData transferData) {
        FinancePaymentSession session = this.getPaymentSession();
        String baseFileName = PaymentReportHelper.getFileName((boolean)true, (boolean)true, (String)(FILE_NAME_PREFIX + session.getCompany().getCode()), (FinancePaymentSession)session);
        String fileName = baseFileName.concat(this.buildFileNameSuffix(transferData)).concat(".xml");
        return StringMapper.removeChars((String)fileName, (char[])new char[]{' '});
    }

    private PaymentTransferService getPaymentTransferService() {
        return this.isDirectDebit() ? new DebitService3() : new CreditService3();
    }

    private PaymentTransferDataMapper getPaymentTransferDataMapper() {
        Iso20022ChFieldFormatter formatter = this.createFormatter();
        return this.isDirectDebit() ? new DebitTransferDataMapper(formatter) : new CreditTransferDataMapper(formatter);
    }

    private Iso20022ChFieldFormatter createFormatter() {
        return new Iso20022ChFieldFormatter(new Iso20022ChEscapeHandler(this.getPaymentSession().getIBankAccount()));
    }

    private String buildFileNameSuffix(PaymentTransferData transferData) {
        StringBuilder suffix = new StringBuilder();
        for (String value : transferData.getGroupByValues()) {
            suffix.append('_').append(value);
        }
        return suffix.toString();
    }

    private boolean isDirectDebit() {
        return this.getPaymentSession().getIsDirectDebit();
    }

    private FinancePaymentSession getPaymentSession() {
        return (FinancePaymentSession)this.mPaymentSessions[0];
    }

    public boolean completeFileName() {
        return false;
    }

    public void createExport() throws BusinessDomainException {
    }

    public LocalizedStringStruct[] getLabel1() {
        return LABELS.getLocalizedStrings(0);
    }

    public LocalizedStringStruct[] getLabel2() {
        return LABELS.getLocalizedStrings(1);
    }

    public LocalizedStringStruct[] getLabel3() {
        return LABELS.getLocalizedStrings(2);
    }
}

