/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso;

import ch.varial.accounting.domain.payment.iso.PaymentTransferDataMapper;
import ch.varial.accounting.domain.payment.iso.data.ChargeBearerType;
import ch.varial.accounting.domain.payment.iso.data.PartyAccount;
import ch.varial.accounting.domain.payment.iso.data.PartyAgent;
import ch.varial.accounting.domain.payment.iso.data.PartyData;
import ch.varial.accounting.domain.payment.iso.data.PaymentInfoData;
import ch.varial.accounting.domain.payment.iso.data.PostalAddressFactory;
import ch.varial.accounting.domain.payment.iso.data.TransactionInfoData;
import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChFieldFormatter;
import ch.varial.accounting.domain.payment.iso.resolver.TransactionTypeResolver;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.paymentbase.SepaDirectDebitTypeEnum;
import com.varial.interfaces.IBankAccount;

public class DebitTransferDataMapper
extends PaymentTransferDataMapper {
    public DebitTransferDataMapper(Iso20022ChFieldFormatter formatter) {
        super(formatter);
    }

    @Override
    protected TransactionType getTransactionType(FinancePayment payment) {
        return new TransactionTypeResolver().resolveDebit(payment);
    }

    @Override
    protected PartyData getPartyData(TransactionType transactionType, FinancePayment payment) {
        return PartyData.builder().withName(this.getPartyName(payment)).withPostalAddress(new PostalAddressFactory(this.formatter).withStructuredFormat().create(payment.getPostalAddress())).build();
    }

    @Override
    protected PartyAgent getPartyAgent(TransactionType transactionType, FinancePayment payment, FinancePaymentSession session) {
        return this.getPartyAgent(transactionType, payment.getBankSortingCode(), null);
    }

    @Override
    protected TransactionType.LocalInstrument getLocalInstrument(TransactionType transactionType, FinancePayment payment) {
        if (transactionType.equals((Object)TransactionType.TYPE_DD)) {
            return this.isCompanyDirectDebit(payment) ? TransactionType.LocalInstrument.DDB2B : TransactionType.LocalInstrument.DDCOR1;
        }
        return this.isCompanyDirectDebit(payment) ? TransactionType.LocalInstrument.BDD : TransactionType.LocalInstrument.LSV_PLUS;
    }

    private boolean isCompanyDirectDebit(FinancePayment payment) {
        return SepaDirectDebitTypeEnum.SDDTE_COMPANY.equals(payment.getSepaDirectDebitType());
    }

    @Override
    protected PartyData getCompanyPartyData(FinancePaymentSession session) throws BusinessDomainException {
        return PartyData.builder().withName(this.getCompanyName(session)).withUniqueId(this.formatter.formatId(this.getCompanyUniqueID(session))).build();
    }

    private String getCompanyUniqueID(FinancePaymentSession session) {
        return session.getIBankAccount().getReferenceSenderBACS();
    }

    @Override
    protected PartyAccount getCompanyPartyAccount(FinancePaymentSession session) {
        return PartyAccount.builder().withIban(this.formatter.formatIban(session.getIBankAccount().getOtherReference())).build();
    }

    @Override
    protected PartyAgent getCompanyPartyAgent(FinancePaymentSession session, TransactionType transactionType) {
        IBankAccount bankAccount = session.getIBankAccount();
        return this.getPartyAgent(transactionType, bankAccount.getBankSortingCode(), bankAccount.getReferenceApplicationBACS());
    }

    private PartyAgent getPartyAgent(TransactionType transactionType, String bankSortingCode, String esrMemberNumber) {
        if (transactionType.equals((Object)TransactionType.TYPE_DD)) {
            return PartyAgent.builder().withBankSortingCode("09000").build();
        }
        return PartyAgent.builder().withBankSortingCode(this.formatter.formatBankSortingCode(bankSortingCode)).withOther(this.formatter.formatEsrMemberNumber(esrMemberNumber)).build();
    }

    @Override
    protected String getTransactionInfoGroupByKey(TransactionInfoData transactionInfoData) {
        return transactionInfoData.getLocalInstrument().value() + "/" + transactionInfoData.getCurrencyCode();
    }

    @Override
    protected String[] getPaymentInfoGroupByValues(PaymentInfoData paymentInfoData) {
        return new String[]{paymentInfoData.getLocalInstrument().value(), paymentInfoData.getCurrencyCode()};
    }

    @Override
    protected ChargeBearerType getChargeBearer(FinancePayment payment) {
        return null;
    }
}

