/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso;

import ch.varial.accounting.domain.payment.iso.PaymentTransferDataMapper;
import ch.varial.accounting.domain.payment.iso.data.ChargeBearerType;
import ch.varial.accounting.domain.payment.iso.data.PartyAccount;
import ch.varial.accounting.domain.payment.iso.data.PartyAgent;
import ch.varial.accounting.domain.payment.iso.data.PartyData;
import ch.varial.accounting.domain.payment.iso.data.PaymentInfoData;
import ch.varial.accounting.domain.payment.iso.data.PostalAddressFactory;
import ch.varial.accounting.domain.payment.iso.data.TransactionInfoData;
import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChFieldFormatter;
import ch.varial.accounting.domain.payment.iso.resolver.TransactionTypeResolver;
import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.text.TextFactory;
import com.varial.serverbase.mapper.StringMapper;

public class CreditTransferDataMapper
extends PaymentTransferDataMapper {
    public CreditTransferDataMapper(Iso20022ChFieldFormatter formatter) {
        super(formatter);
    }

    @Override
    protected TransactionType getTransactionType(FinancePayment payment) {
        return new TransactionTypeResolver().resolveCredit(payment);
    }

    @Override
    protected PartyData getPartyData(TransactionType transactionType, FinancePayment payment) {
        if (transactionType.equals((Object)TransactionType.TYPE_1)) {
            return PartyData.builder().withName(this.getPartyName(payment)).build();
        }
        if (transactionType.equals((Object)TransactionType.TYPE_6)) {
            return PartyData.builder().withName(this.getPartyName(payment)).withPostalAddress(new PostalAddressFactory(this.formatter).withUnstructuredFormat().create(payment.getPostalAddress())).build();
        }
        return PartyData.builder().withName(this.getPartyName(payment)).withPostalAddress(new PostalAddressFactory(this.formatter).withStructuredFormat().create(payment.getPostalAddress())).build();
    }

    @Override
    protected PartyAgent getPartyAgent(TransactionType transactionType, FinancePayment payment, FinancePaymentSession session) {
        switch (transactionType) {
            case TYPE_1: {
                return null;
            }
            case TYPE_21: {
                return null;
            }
            case TYPE_3: {
                return this.getPartyAgentType3(payment);
            }
            case TYPE_4: {
                return this.getPartyAgentType4(payment, session);
            }
            case TYPE_6: {
                return this.getPartyAgentType6(payment);
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)((Object)transactionType)));
    }

    private PartyAgent getPartyAgentType3(FinancePayment payment) {
        if (!StringMapper.isNullString((String)payment.getBankSortingCode())) {
            return PartyAgent.builder().withBankSortingCode(this.formatter.formatBankSortingCode(payment.getBankSortingCode())).build();
        }
        if (!StringMapper.isNullString((String)payment.getSwift())) {
            return PartyAgent.builder().withBic(this.formatter.formatSwift(payment.getSwift())).build();
        }
        return null;
    }

    private PartyAgent getPartyAgentType4(FinancePayment payment, FinancePaymentSession session) {
        if (!StringMapper.isNullString((String)payment.getSwift())) {
            return PartyAgent.builder().withBic(this.formatter.formatSwift(payment.getSwift())).build();
        }
        if (!StringMapper.isNullString((String)payment.getBankSortingCode())) {
            return PartyAgent.builder().withBankSortingCode(this.formatter.formatBankSortingCode(payment.getBankSortingCode())).withName(this.getBankName(payment)).withPostalAddress(this.getBankPostalAddress(payment, session)).build();
        }
        return null;
    }

    private PartyAgent getPartyAgentType6(FinancePayment payment) {
        if (!StringMapper.isNullString((String)payment.getSwift())) {
            return PartyAgent.builder().withBic(this.formatter.formatSwift(payment.getSwift())).build();
        }
        return null;
    }

    @Override
    protected TransactionType.LocalInstrument getLocalInstrument(TransactionType transactionType, FinancePayment payment) {
        switch (transactionType) {
            case TYPE_1: {
                return TransactionType.LocalInstrument.CH01;
            }
            case TYPE_21: {
                return TransactionType.LocalInstrument.CH02;
            }
        }
        return null;
    }

    @Override
    protected PartyData getCompanyPartyData(FinancePaymentSession session) throws BusinessDomainException {
        PartyData.Builder builder = PartyData.builder().withName(this.getCompanyName(session));
        if (StringUtil.isNotEmpty((String)session.getIBankAccount().getReferenceReceiverBACS())) {
            builder.withPostalAddress(this.createCompanyPostalAddress(session));
        }
        return builder.build();
    }

    @Override
    protected PartyAccount getCompanyPartyAccount(FinancePaymentSession session) {
        if (!StringMapper.isNullString((String)session.getIBankAccount().getOtherReference())) {
            return PartyAccount.builder().withIban(this.formatter.formatIban(session.getIBankAccount().getOtherReference())).build();
        }
        return PartyAccount.builder().withOther(this.formatter.formatBankAccountNumber(session.getIBankAccount().getBankAccountNumber())).build();
    }

    @Override
    protected PartyAgent getCompanyPartyAgent(FinancePaymentSession session, TransactionType transactionType) {
        if (transactionType.equals((Object)TransactionType.TYPE_6)) {
            if (!StringMapper.isNullString((String)session.getIBankAccount().getSwift())) {
                return PartyAgent.builder().withBic(this.formatter.formatSwift(session.getIBankAccount().getSwift())).build();
            }
            if (!StringMapper.isNullString((String)session.getIBankAccount().getBankSortingCode())) {
                return PartyAgent.builder().withBankSortingCode(this.formatter.formatBankSortingCode(session.getIBankAccount().getBankSortingCode())).build();
            }
            return null;
        }
        if (!StringMapper.isNullString((String)session.getIBankAccount().getBankSortingCode())) {
            return PartyAgent.builder().withBankSortingCode(this.formatter.formatBankSortingCode(session.getIBankAccount().getBankSortingCode())).build();
        }
        if (!StringMapper.isNullString((String)session.getIBankAccount().getSwift())) {
            return PartyAgent.builder().withBic(this.formatter.formatSwift(session.getIBankAccount().getSwift())).build();
        }
        return null;
    }

    @Override
    protected String[] getPaymentInfoGroupByValues(PaymentInfoData paymentInfoData) {
        return new String[0];
    }

    @Override
    protected String getTransactionInfoGroupByKey(TransactionInfoData transactionInfoData) {
        return transactionInfoData.getTransactionType().value() + "/" + transactionInfoData.getCurrencyCode();
    }

    @Override
    protected ChargeBearerType getChargeBearer(FinancePayment payment) {
        if (payment.getPersonalAccount() == null || payment.getPersonalAccount().getExpenseArrangementType() == null) {
            return null;
        }
        switch (payment.getPersonalAccount().getExpenseArrangementType()) {
            case BOTH: {
                return ChargeBearerType.SHAR;
            }
            case RECEIVER: {
                return ChargeBearerType.BEN;
            }
            case SENDER: {
                return ChargeBearerType.OUR;
            }
        }
        return null;
    }
}

