/*
 * Decompiled with CFR 0.152.
 */
package bg.varial.accounting.domain.payment.multicash.version3;

import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.List;

public class MulticashBGForeignPaymentLineGeneratorImpl
extends bg.varial.accounting.domain.payment.multicash.version2.MulticashBGForeignPaymentLineGeneratorImpl {
    public MulticashBGForeignPaymentLineGeneratorImpl(PaymentSession[] sessions, LineSeparator lineSeparator) throws BusinessDomainException {
        super(sessions, lineSeparator);
    }

    protected List<OutputField> getBeneficiaryAddress(Payment payment) {
        ArrayList<OutputField> fields = new ArrayList<OutputField>();
        CustSupAddress address = PaymentHelper.getCustSupAddress(payment);
        if (address == null) {
            return fields;
        }
        PostalAddress postalAddress = address.getPostalAddress();
        this.addAddressLine(fields, postalAddress.getName(), true);
        this.addAddressLine(fields, postalAddress.getStreet(), true);
        String postalCodeTown = String.join((CharSequence)" ", StringMapper.toStringWithTrim((String)postalAddress.getPostalCode()), StringMapper.toStringWithTrim((String)postalAddress.getTown()));
        this.addAddressLine(fields, postalCodeTown, false);
        return fields;
    }

    protected int getMaxLengthForField70() {
        return 35;
    }
}

