/*
 * Decompiled with CFR 0.152.
 */
package bg.varial.accounting.domain.payment.multicash;

import bg.varial.accounting.domain.payment.multicash.MulticashBGBasePaymentLineGenerator;
import bg.varial.accounting.domain.payment.multicash.MulticashBGCharacterConverter;
import bg.varial.accounting.domain.payment.multicash.MulticashBGPaymentHelper;
import com.varial.accounting.domain.bankaccount.IBankData;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.resolver.PersonalAccountBankAddressResolver;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.text.TextFactory;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.domain.textoutput.OutputCharacterConverter;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.OutputLine;
import com.varial.serverbase.domain.textoutput.TextField;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class MulticashBGBaseForeignPaymentLineGeneratorImpl
extends MulticashBGBasePaymentLineGenerator {
    protected MulticashBGBaseForeignPaymentLineGeneratorImpl(PaymentSession[] sessions, LineSeparator lineSeparator) throws BusinessDomainException {
        super(sessions, lineSeparator, (OutputCharacterConverter)new MulticashBGCharacterConverter());
    }

    public OutputLine createHeaderLine() {
        ArrayList<Object> fields = new ArrayList<Object>();
        String referenceNumber = MulticashBGPaymentHelper.getField20((Date)this.creationDate, (String)this.paymentCountForDate);
        fields.add(new TextField(":01:".concat(referenceNumber)));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":02:".concat(MulticashBGPaymentHelper.formatAmount((BigDecimal)this.paymentSum))));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":03:".concat(String.valueOf(this.paymentList.size()))));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":04:".concat(this.bankAccount.getSwift())));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":05:".concat(this.toAddressField(this.companyAddress.getName()))));
        fields.add(this.lineSeparator);
        fields.add(new TextField(this.toAddressField(this.companyAddress.getStreet())));
        fields.add(this.lineSeparator);
        fields.add(new TextField(this.toAddressField(this.companyAddress.getTown())));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":06:"));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":07:"));
        fields.add(this.lineSeparator);
        return new OutputLine(fields.toArray(new OutputField[0]));
    }

    public OutputLine createPaymentLine(Payment payment, int paymentNumber) throws BusinessDomainException {
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(new TextField(":20:".concat(MulticashBGPaymentHelper.getField20((Date)this.creationDate, (String)this.paymentCountForDate, (int)paymentNumber))));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":32A:".concat(MulticashBGPaymentHelper.getField32A((Date)this.creationDate, (Payment)payment))));
        fields.add(this.lineSeparator);
        if (this.withField50()) {
            fields.addAll(this.getOutputField50());
            fields.add(this.lineSeparator);
        }
        fields.addAll(this.getOutputField52A());
        fields.add(this.lineSeparator);
        fields.addAll(this.getOutputField57(payment));
        fields.addAll(this.getOutputField59(payment));
        fields.add(this.lineSeparator);
        fields.addAll(this.getOutputField70(payment));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":71A:".concat(MulticashBGPaymentHelper.getExpenseArrangementType((Payment)payment))));
        fields.add(this.lineSeparator);
        fields.add(new TextField(":72:SPOT"));
        fields.add(this.lineSeparator);
        return new OutputLine(fields.toArray(new OutputField[0]));
    }

    protected boolean withField50() {
        return true;
    }

    public OutputLine createPaymentLineForDirectDebit(Payment payment, int paymentNumber) throws BusinessDomainException {
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)"DD"));
    }

    private List<OutputField> getOutputField50() {
        ArrayList<OutputField> fields = new ArrayList<OutputField>();
        fields.add((OutputField)new TextField(":50:".concat(this.toAddressField(this.companyAddress.getName()))));
        fields.add((OutputField)this.lineSeparator);
        fields.add((OutputField)new TextField(this.toAddressField(this.companyAddress.getStreet())));
        fields.add((OutputField)this.lineSeparator);
        fields.add((OutputField)new TextField(this.toAddressField(this.companyAddress.getPostalCode())));
        fields.add((OutputField)this.lineSeparator);
        fields.add((OutputField)new TextField(this.toAddressField(this.companyAddress.getTown())));
        return fields;
    }

    private List<OutputField> getOutputField57(Payment payment) {
        ArrayList<OutputField> fields = new ArrayList<OutputField>();
        if (!StringMapper.isNullString((String)payment.getSwift())) {
            fields.add((OutputField)new TextField(":57A:".concat(this.characterConverter.convert(payment.getSwift()))));
            fields.add((OutputField)this.lineSeparator);
        } else {
            fields.add((OutputField)new TextField(":57D:".concat(this.characterConverter.convert(payment.getBankName()))));
            fields.add((OutputField)this.lineSeparator);
            IBankData bankData = PersonalAccountBankAddressResolver.resolveBankData((Payment)payment, (PaymentSession)this.paymentSessions[0]);
            if (bankData != null && bankData.getPostalAddress() != null) {
                if (!StringMapper.isNullString((String)bankData.getPostalAddress().getStreet())) {
                    fields.add((OutputField)new TextField(this.characterConverter.convert(bankData.getPostalAddress().getStreet())));
                    fields.add((OutputField)this.lineSeparator);
                }
                if (!StringMapper.isNullString((String)bankData.getPostalAddress().getPostalCode())) {
                    fields.add((OutputField)new TextField(this.characterConverter.convert(bankData.getPostalAddress().getPostalCode())));
                    fields.add((OutputField)this.lineSeparator);
                }
                if (!StringMapper.isNullString((String)bankData.getPostalAddress().getTown())) {
                    fields.add((OutputField)new TextField(this.characterConverter.convert(bankData.getPostalAddress().getTown())));
                    fields.add((OutputField)this.lineSeparator);
                }
            }
        }
        return fields;
    }

    protected List<OutputField> getOutputField70(Payment payment) throws BusinessDomainException {
        ArrayList<OutputField> fields = new ArrayList<OutputField>();
        String[] paymentDetails = PaymentHelper.getFixedOrFreePaymentDetailsAsArray(payment, this.getMaxLengthForField70(), 4, this.paymentDetailsHolder);
        String pd1 = this.getArrayValue(paymentDetails, 0);
        String pd2 = this.getArrayValue(paymentDetails, 1);
        String pd3 = this.getArrayValue(paymentDetails, 2);
        String pd4 = this.getArrayValue(paymentDetails, 3);
        fields.add((OutputField)new TextField(":70:".concat(pd1)));
        this.addOptionalField70Line(fields, pd2, true);
        this.addOptionalField70Line(fields, pd3, false);
        this.addOptionalField70Line(fields, pd4, false);
        return fields;
    }

    private String getArrayValue(String[] values, int index) {
        return values.length > index ? values[index] : "";
    }

    private void addOptionalField70Line(List<OutputField> fields, String value, boolean withIdentifier) {
        if (!StringMapper.isNullString((String)value)) {
            fields.add((OutputField)this.lineSeparator);
            String text = withIdentifier ? ":70:".concat(value) : value;
            fields.add((OutputField)new TextField(text));
        }
    }

    protected int getMaxLengthForField70() {
        return 140;
    }

    private List<OutputField> getOutputField59(Payment payment) {
        ArrayList<OutputField> fields = new ArrayList<OutputField>();
        fields.add((OutputField)new TextField(":59:/".concat(this.getValueOfField59(payment))));
        List<OutputField> beneficiaryAddress = this.getBeneficiaryAddress(payment);
        if (!beneficiaryAddress.isEmpty()) {
            fields.add((OutputField)this.lineSeparator);
            fields.addAll(beneficiaryAddress);
        }
        return fields;
    }

    protected List<OutputField> getBeneficiaryAddress(Payment payment) {
        ArrayList<OutputField> fields = new ArrayList<OutputField>();
        CustSupAddress address = PaymentHelper.getCustSupAddress(payment);
        if (address == null) {
            return fields;
        }
        PostalAddress postalAddress = address.getPostalAddress();
        this.addAddressLine(fields, postalAddress.getName(), true);
        this.addAddressLine(fields, postalAddress.getStreet(), true);
        this.addAddressLine(fields, postalAddress.getPostalCode(), true);
        this.addAddressLine(fields, postalAddress.getTown(), false);
        return fields;
    }

    protected void addAddressLine(List<OutputField> fields, String value, boolean withSeparator) {
        fields.add((OutputField)new TextField(this.toAddressField(value)));
        if (withSeparator) {
            fields.add((OutputField)this.lineSeparator);
        }
    }

    protected abstract List<OutputField> getOutputField52A();

    protected abstract String getValueOfField59(Payment var1);
}

